//%attributes = {"publishedSql":true}
// Method: _tcp_ BlobSend
// 2004.03.23-15:42:02 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// see: _tcp_ BlobReceive, _rct_BlobSend, _zmq_ BlobSend, _zmq_ BlobReceive
// ------------------------------------------------------------
If (<>_tcp_ lProfile>0)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($0; $1; $_tcp_lSocket; $_tcp_lBlobSize; $_tcp_lSourceOffset; $_tcp_lDestinationOffset; $_tcp_lErr; $_tcp_lBytesSent; $_tcp_lStatus)
C_LONGINT:C283($_tcp_lBytesToCopy; $_tcp_lBytesLeftToCopy; $_tcp_lBytesSentPrev; $_tcp_lDelayMillisStart)
C_REAL:C285($_tcp_rTimeDifference)
C_POINTER:C301($2; $_tcp_pBlob)  //blob
C_BLOB:C604($_tcp_xTmpSendBlob)
C_TEXT:C284($_tcp_tPlgError)

$_tcp_lSocket:=$1
$_tcp_pBlob:=$2
$_tcp_lErr:=0
$_tcp_lSourceOffset:=0
$_tcp_lBlobSize:=BLOB size:C605($_tcp_pBlob->)

Case of 
	: (_tcp_lTcpPlugInType=-1)  //MA_Tcp
		$_tcp_lBytesLeftToCopy:=$_tcp_lBlobSize
		$_tcp_lLoopCount:=0
		$_tcp_lDelayMillisStart:=Milliseconds:C459
		_tcp_lTimeOut:=<>_tcp_lBlobSendTimeout
		_tcp_lTimeOutStart:=Tickcount:C458
		
		Repeat 
			$_tcp_lBytesSentPrev:=$_tcp_lBytesSent
			$_tcp_lLoopCount:=$_tcp_lLoopCount+1
			
			If ($_tcp_lLoopCount>=2)
				
				If (<>_tcp_ lProfile>0)
					_info_ CALL_PROFILE(kStart; Current method name:C684+": delay")
				End if 
				$_tcp_rTimeDifference:=_time MillisecondsDifference(Milliseconds:C459; $_tcp_lDelayMillisStart; 4)
				Case of 
					: ($_tcp_rTimeDifference<=_tcp_rBlobReceiveDelay1Time)
						//_time_ DELAY (_tcp_lDelayOnReceive)
						DELAY PROCESS:C323(Current process:C322; _tcp_lDelayOnReceive)
					Else 
						//_time_ DELAY (_tcp_lDelayOnReceive2) 
						DELAY PROCESS:C323(Current process:C322; _tcp_lDelayOnReceive2)
				End case 
				If (<>_tcp_ lProfile>0)
					_info_ CALL_PROFILE(kStop; Current method name:C684+": delay")
				End if 
				
			End if 
			C_BLOB:C604(_tcp_xBlob)
			SET BLOB SIZE:C606(_tcp_xBlob; 0)
			COPY BLOB:C558($_tcp_pBlob->; _tcp_xBlob; 0; 0; BLOB size:C605($_tcp_pBlob->))
			$_tcp_lErr:=MA_TCP_SendBlob($_tcp_lSocket; _tcp_xBlob; $_tcp_lSourceOffset; $_tcp_lBytesLeftToCopy)
			SET BLOB SIZE:C606(_tcp_xBlob; 0)
			Case of 
				: ($_tcp_lErr=-730054)  // -730054, 730054: An existing connection was forcibly closed by the remote host.
					_tcp_ SOCKET_CLOSE($_tcp_lSocket)
					$_tcp_lErr:=-1  // close
				: ($_tcp_lErr=-730035)  // resouce temporarily unavailable = send again
					$_tcp_lErr:=0
				: ($_tcp_lErr=-70007)  // resouce temporarily unavailable = send again
					$_tcp_lErr:=0
				: ($_tcp_lErr=-35)  // resouce temporarily unavailable = send again
					$_tcp_lErr:=0
				: ($_tcp_lErr=-1)
					//closed socket, ok for status check
				: ($_tcp_lErr<0)  //real error
					_tcp_MA_TCP_ERROR($_tcp_lSocket; $_tcp_lErr; "MA_TCP_SendBlob"; Current method name:C684)
				Else 
					// ok
			End case 
			
			$_tcp_lBytesLeftToCopy:=$_tcp_lBlobSize-$_tcp_lSourceOffset
			Case of 
				: ($_tcp_lErr>=0)
					If ($_tcp_lBytesLeftToCopy#0)
						DELAY PROCESS:C323(Current process:C322; 0)
					End if 
				Else   //($_tcp_lBytesSent=0) == `If ($_tcp_lSourceOffset=$_tcp_lBytesSentPrev)
					IDLE:C311
					If ($_tcp_lErr#-1)
						$_tcp_lErr:=_tcp_TimeOutReached
					End if 
					//$_tcp_lBytesSent=0, error  will be shown only if MA_TCP_GetLastErrorText returns something
					//_tcp_MA_TCP_ERROR ($_tcp_lSocket;$_tcp_lBytesSent;"MA_TCP_SendBlob";Current method name)
			End case 
			
		Until (($_tcp_lBytesLeftToCopy<=0) | ($_tcp_lErr<0))
		
		If ($_tcp_lErr=-100)
			//$_tcp_lErr:=-2  `exit by timeout
			$_tcp_lStatus:=_tcp_ StatusGet($_tcp_lSocket)
			_err MESSAGE("TCP Send Blob timeout, status: "+String:C10($_tcp_lStatus); Current method name:C684; kFalse)
		End if 
		
		//If ($_tcp_lBytesLeftToCopy#0)
		//  `If ($_tcp_lErr>=0)
		//_err MESSAGE ("TCP Send Blob error, bytes left to copy: "+String($_tcp_lBytesLeftToCopy)+" / "+String($_tcp_lBlobSize)+", socket: "+String($_tcp_lSocket);Current method name;kFalse )
		//  `End if 
		//End if 
		
		If ($_tcp_lSourceOffset<$_tcp_lBlobSize)
			$_tcp_lErr:=-1
		End if 
		
	: (_tcp_lTcpPlugInType=0)  //NTK
		$_tcp_lBytesToCopy:=_tcp_lBlobPacketSizeNTK
		$_tcp_lBytesLeftToCopy:=$_tcp_lBlobSize
		$_tcp_lLoopCount:=0
		_tcp_lTimeOut:=<>_tcp_lBlobSendTimeout
		_tcp_lTimeOutStart:=Tickcount:C458
		Repeat 
			$_tcp_lLoopCount:=$_tcp_lLoopCount+1
			$_tcp_lDestinationOffset:=0
			If ($_tcp_lBytesToCopy>$_tcp_lBytesLeftToCopy)
				$_tcp_lBytesToCopy:=$_tcp_lBytesLeftToCopy
			End if 
			$_tcp_lBytesSentPrev:=$_tcp_lBytesSent
			If ($_tcp_lBlobSize>_tcp_lBlobPacketSizeNTK)
				// necessary to send blob in smaller pieces
				SET BLOB SIZE:C606($_tcp_xTmpSendBlob; 0)  //this MUST be done
				COPY BLOB:C558($_tcp_pBlob->; $_tcp_xTmpSendBlob; $_tcp_lSourceOffset; $_tcp_lDestinationOffset; $_tcp_lBytesToCopy)
				//$_tcp_lBytesSent:=TCP Send Blob ($_tcp_lSocket;$_tcp_xTmpSendBlob)  //--> bytes send
			Else 
				//$_tcp_lBytesSent:=TCP Send Blob ($_tcp_lSocket;$_tcp_pBlob->)  //--> bytes send      
			End if 
			If ($_tcp_lBytesSent>0)
				$_tcp_lSourceOffset:=$_tcp_lSourceOffset+$_tcp_lBytesSent
				$_tcp_lBytesLeftToCopy:=$_tcp_lBlobSize-$_tcp_lSourceOffset
			End if 
			
			If ($_tcp_lSourceOffset=$_tcp_lBytesSentPrev)
				$_tcp_lErr:=_tcp_TimeOutReached
			End if 
			
			If ($_tcp_lErr=-100)
				$_tcp_lErr:=-1  //exit by timeout
				$_tcp_lStatus:=_tcp_ StatusGet($_tcp_lSocket)
				_err MESSAGE("TCP Send Blob timeout, status: "+String:C10($_tcp_lStatus); Current method name:C684; kFalse)
			End if 
			
			IDLE:C311
		Until (($_tcp_lBytesLeftToCopy<=0) | ($_tcp_lErr<0))
		If ($_tcp_lBytesLeftToCopy<0)
			_err MESSAGE("Tcp send error, bytes left to copy < 0"+", socket: "+String:C10($_tcp_lSocket); Current method name:C684; kFalse)
		End if 
		
		If ($_tcp_lSourceOffset<$_tcp_lBlobSize)
			$_tcp_lErr:=-1
		End if 
		
		//: (_tcp_lTcpPlugInType=1)
		//  `COMPILER__tcp_ip 
		//
		//  `$_tcp_lErr:=ITK_TCPSendBlob ($_tcp_lSocket;$_tcp_pBlob->;flushFlag;filterFlag;
		//  `~startOffset;endOffset)
		//Case of 
		//: (◊_tcp_lSendTypeITK=0)
		//$_tcp_lErr:=ITK_TCPSendBlob($_tcp_lSocket;$_tcp_pBlob->)
		//: (◊_tcp_lSendTypeITK=1)
		//$_tcp_lErr:=ITK_TCPSendBlob($_tcp_lSocket;$_tcp_pBlob->;0;0;0;0)
		//: (◊_tcp_lSendTypeITK=2)
		//$_tcp_lErr:=ITK_TCPSendBlob($_tcp_lSocket;$_tcp_pBlob->;1;0;0;0)
		//: (◊_tcp_lSendTypeITK=3)
		//If ($_tcp_lBlobSize<256)
		//$_tcp_lErr:=ITK_TCPSendBlob($_tcp_lSocket;$_tcp_pBlob->;0;0;0;0)  `no buffer
		//Else 
		//$_tcp_lErr:=ITK_TCPSendBlob($_tcp_lSocket;$_tcp_pBlob->;$_tcp_lBlobSize;0;0;0)
		//End if 
		//Else 
		//Repeat 
		//$_tcp_lErr:=_tcp_ TextSend ($_tcp_lSocket;BLOB to text($_tcp_pBlob->;Mac text without length ;$_tcp_lSourceOffset;_tcp_lBlobPacketSize))
		//IDLE
		//Until (($_tcp_lSourceOffset>=$_tcp_lBlobSize) | ($_tcp_lErr<0))
		//End case 
		
	: (_tcp_lTcpPlugInType=2)
		Repeat 
			$_tcp_lErr:=_tcp_ TextSend($_tcp_lSocket; BLOB to text:C555($_tcp_pBlob->; Mac text without length:K22:10; $_tcp_lSourceOffset; _tcp_lBlobPacketSize))
			IDLE:C311
		Until (($_tcp_lSourceOffset>=$_tcp_lBlobSize) | ($_tcp_lErr<0))
		
	Else 
		TRACE:C157
End case 

If ($_tcp_lSourceOffset>$_tcp_lBlobSize)
	_err MESSAGE("Tcp send error, more than the blob size data was sent: "+String:C10($_tcp_lSourceOffset)+" / "+String:C10($_tcp_lBlobSize)+", socket: "+String:C10($_tcp_lSocket); Current method name:C684; kFalse)
End if 

Case of 
	: ($_tcp_lErr<0)
		$0:=$_tcp_lErr
	Else 
		$0:=$_tcp_lSourceOffset
End case 

If ($_tcp_lLoopCount>3)  // & ($_tcp_lErr>=0))
	If (_usr Designer=kTrue)
		$_tcp_tPlgError:=MA_TCP_GetLastErrorText($_tcp_lSocket)
		_err MESSAGE("_tcp_ BlobSend done in many loops: "+String:C10($_tcp_lLoopCount)+" loops / "+String:C10($_tcp_lBlobSize; "|byte")+", error: "+$_tcp_tPlgError; Current method name:C684; kFalse)
	End if 
End if 

If (<>_tcp_ lProfile>0)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
